CREATE SCHEMA IF NOT EXISTS botdb;

CREATE TABLE botdb.links
(
    uid text NOT NULL,
    email text NOT NULL,
    chat_id text NOT NULL,
    bot_id text NOT NULL,
    bot_platform text NOT NULL,
    extra jsonb NOT NULL DEFAULT '{}'::jsonb,

    -- Currently we support only one mail account per bot
    -- But if we want to remove this restriction in future it would be hard to do when botpeer is primary key
    -- So we add uid to primary key, and unique constraint to botpeer, so we can delete constraint later if needed
    CONSTRAINT pk_links PRIMARY KEY (uid, chat_id, bot_id, bot_platform),
    CONSTRAINT uk_links_botpeer UNIQUE (chat_id, bot_id, bot_platform)
);

CREATE TABLE botdb.otps
(
    uid text NOT NULL,
    email text NOT NULL,
    chat_id text NOT NULL,
    bot_id text NOT NULL,
    bot_platform text NOT NULL,
    otp_value text NOT NULL,
    extra jsonb NOT NULL DEFAULT '{}'::jsonb,
    creation_ts timestamp with time zone DEFAULT current_timestamp,
    CONSTRAINT pk_otps PRIMARY KEY (uid, chat_id, bot_id, bot_platform),
    CONSTRAINT uk_otps_botpeer UNIQUE (chat_id, bot_id, bot_platform)
);
