#!/bin/bash

set -eo pipefail

function exists {
    type $1 &> /dev/null
}

if ! exists pgmigrate; then
    echo "pgmigrate not found, run pip3 install yandex-pgmigrate";
    exit 1;
fi;

if [[ -z "$1" ]]; then
    echo "usage: pgaas_deploy.sh <conninfo>"
    exit 1;
fi

pgmigrate -c "$1" -d "." -t latest -a "afterAll:code/,afterAll:grants/" migrate -vv
