#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
prefix="http.requests."

function run()
{
    timetail -n 60 -r '^tskv\ttskv_format=botserver-httpout-log\ttimestamp=.{11}(\d\d:\d\d:\d\d)' $1 | head -n -1 | \
    awk -v prefix=$prefix -v ts=$ts '
        @include "/usr/share/yandex-mail-common/metrics-util.awk"

        {
            host = get_tskv_value($0, "host")
            gsub("\\.", "_", host)
            host = host "_" get_tskv_value($0, "port")
            status = get_tskv_value($0, "status")
            error = get_tskv_value($0, "error")
            gsub(" ", "_", error)
            tm = get_tskv_value($0, "total_time")
            attempt = get_tskv_value($0, "attempt")
            if (length(host) > 0 &&
                length(status) > 0 &&
                length(error) > 0 &&
                length(tm) > 0 &&
                length(attempt) > 0) # filter malformed entries
            {
                http[host ".codes." status]++
                http[host ".attempts." attempt]++
                http[host ".errors." error]++
                collect_timings(tm, host, host_tm)
            }
        }
        END {
            for (metric in http) {
                print prefix metric, http[metric], ts
            }
            for (host in host_tm) {
                print prefix host ".timings", "[" host_tm[host] "]", ts
            }
        }'
}

run /var/log/botserver/httpout.log
