#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

timetail -r '^tskv\ttskv_format=botserver-log\ttimestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' -n 60 /var/log/botserver/typed.log | head -n -1 \
    | awk -v ts=$(date +%s) '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /type=message_processed/ {
        $0 = tolower($0);
        status = get_tskv_value($0, "status")
        command = get_tskv_value($0, "command")
        rc_wait_time = get_tskv_value($0, "rc_wait_time")
        process_time = get_tskv_value($0, "process_time")
        command_statuses[command "." status]++
        command_statuses["total." status]++
        collect_timings(rc_wait_time, command, command_rc_wait_timings)
        collect_timings(process_time, command, command_process_timings)
    }

    /type=mail_message_sent/ {
        $0 = tolower($0);
        status = get_tskv_value($0, "status")
        sent_time = get_tskv_value($0, "sent_time")
        mail_sent_statuses[status]++
        collect_timings(sent_time, "", mail_sent_timings)
    }

    END {
        for (c in command_statuses) {
            print "commands.statuses." c, command_statuses[c], ts
        }
        for (c in command_rc_wait_timings) {
            print "commands.rc_wait_timings." c, "[" command_rc_wait_timings[c] "]", ts
        }
        for (c in command_process_timings) {
            print "commands.process_timings." c, "[" command_process_timings[c] "]", ts
        }
        for (c in mail_sent_statuses) {
            print "mail.sent.statuses." c, mail_sent_statuses[c], ts
        }
        for (c in mail_sent_timings) {
            print "mail.sent.timings." c, mail_sent_timings[c], ts
        }
    }'
