#pragma once

#include <messenger/gate.h>
#include <ymod_webserver/response.h>

namespace botserver::api {

void disable_processing(ymod_webserver::http::stream_ptr stream, unsigned int ttl_sec)
{
    auto gate = find_module<messenger::gate>("telegram_gate");
    gate->disable_processing(stream->ctx(), seconds(ttl_sec));
    stream->result(ymod_webserver::codes::ok);
}

}
