#pragma once

#include <common/botpeer.h>
#include <common/mail_account.h>
#include <common/types.h>

namespace botserver::auth {

struct account_provider
{
    virtual future<optional<mail_account>> get_mail_account(
        task_context_ptr ctx,
        botpeer botpeer,
        string email) = 0;

    virtual ~account_provider() = default;
};

using account_provider_ptr = shared_ptr<account_provider>;

}
