#pragma once

#include "platforms.h"
#include "types.h"

namespace botserver {

struct botpeer
{
    platform_name platform;
    string bot_id;
    string chat_id;
    string username;
    // additional: messenger user_id (!= chat_id)

    bool operator==(const botpeer& other) const
    {
        return std::tie(platform, bot_id, chat_id) ==
            std::tie(other.platform, other.bot_id, other.chat_id);
    }

    bool operator<(const botpeer& other) const
    {
        return std::tie(platform, bot_id, chat_id) <
            std::tie(other.platform, other.bot_id, other.chat_id);
    }
};

}

namespace std {

template <>
struct hash<botserver::botpeer>
{
    std::size_t operator()(const botserver::botpeer& botpeer) const noexcept
    {
        size_t seed = 0;
        boost::hash_combine(seed, std::hash<int>{}(static_cast<int>(botpeer.platform)));
        boost::hash_combine(seed, std::hash<std::string>{}(botpeer.bot_id));
        boost::hash_combine(seed, std::hash<std::string>{}(botpeer.chat_id));
        return seed;
    }
};

}