#pragma once

namespace botserver {

inline string get_exception_reason(std::exception_ptr e)
{
    std::string reason;
    if (!e) return reason;

    try
    {
        std::rethrow_exception(e);
    }
    catch (const std::exception& error)
    {
        reason = error.what();
    }
    catch (...)
    {
        reason = "unknown";
    }
    return reason;
}

template <typename Future>
string get_exception_reason(const Future f)
{
    return get_exception_reason(f.get_exception());
}

}
