#pragma once

#include <i18n/i18n.h>
#include "types.h"

namespace botserver {

struct attachment_meta
{
    string id;
    string file_name;
    string mime_type;
    size_t size = 0;
};

struct gate_message
{
    i18n::language lang = i18n::language::ru;
    string text;
    time_t received_date = 0;
    vector<attachment_meta> attachments;
    // botpeer from
    optional<message_author> forwarded_from;
    // attributes
};

using gate_message_ptr = shared_ptr<gate_message>;

}