#pragma once

#include <common/types.h>
#include <yplatform/json.h>

namespace botserver {

using yplatform::json_value;

class json_field_exception : public runtime_error
{
public:
    using runtime_error::runtime_error;
};

template <typename T, bool flag = false>
T assert_not_supported_type()
{
    static_assert(flag, "unsupported type");
}

template <typename T>
T convert_json(json_value json)
{
    if constexpr (std::is_same_v<json_value, std::decay_t<T>>)
    {
        return json;
    }
    else if constexpr (std::is_same_v<string, std::decay_t<T>>)
    {
        return json.to_string();
    }
    else if constexpr (std::is_same_v<int64_t, std::decay_t<T>>)
    {
        return json.to_int64();
    }
    else if constexpr (std::is_same_v<uint64_t, std::decay_t<T>>)
    {
        return json.to_uint64();
    }
    else if constexpr (std::is_same_v<bool, std::decay_t<T>>)
    {
        return json.to_bool();
    }
    else
    {
        return assert_not_supported_type<T>();
    }
}

template <typename T>
T get_required_field(json_value json, string field)
{
    if (!json.has_member(field)) throw json_field_exception("required filed not found: " + field);
    return convert_json<T>(json[field]);
}

template <typename T>
T get_optional_field(json_value json, string field, T def = T())
{
    if (!json.has_member(field)) return def;
    return convert_json<T>(json[field]);
}

}
