#pragma once

#include <common/types.h>

namespace botserver {

inline string get_my_ip()
{
    using namespace boost::asio;
    using resolver_t = ip::tcp::resolver;
    io_service io;
    resolver_t resolver(io);
    string hostname = ip::host_name();
    resolver_t::query query(hostname, "");
    auto it = resolver.resolve(query);
    if (it == resolver_t::iterator())
    {
        throw runtime_error("can't get my ip: no endpoints for given hostname: " + hostname);
    }
    resolver_t::endpoint_type endpoint = *it;
    return endpoint.address().to_string();
}

const string my_ip = get_my_ip();
const unsigned my_port = 443;
const string my_host_name = boost::asio::ip::host_name();

}
