#pragma once

#include <yplatform/find.h>
#include <yplatform/future/future.hpp>
#include <yplatform/time_traits.h>
#include <yplatform/task_context.h>
#include <boost/system/error_code.hpp>
#include <boost/serialization/strong_typedef.hpp>
#include <string>
#include <vector>
#include <map>
#include <memory>
#include <functional>
#include <exception>
#include <optional>
#include <atomic>
#include <mutex>

#define capture_self self = shared_from(this)

namespace botserver {

using std::string;
using std::pair;
using std::vector;
using std::map;
using std::set;
using std::function;
using std::shared_ptr;
using std::make_shared;
using std::exception;
using std::runtime_error;
using std::optional;
using std::exception;
using std::function;
using std::atomic;
using std::mutex;
using std::lock_guard;
using boost::system::error_code;
using yplatform::task_context;
using yplatform::task_context_ptr;
using yplatform::future::future;
using yplatform::future::promise;
using yplatform::future::make_future;
using yplatform::shared_from;

BOOST_STRONG_TYPEDEF(string, markdown_string);
BOOST_STRONG_TYPEDEF(string, html_string);

using string_ptr = shared_ptr<string>;

namespace ph = std::placeholders;
using namespace yplatform::time_traits;

template <typename Module, typename... Args>
auto find_module(Args&&... args)
{
    return yplatform::find<Module, shared_ptr>(std::forward<Args>(args)...);
}

}