#pragma once

#include <common/botpeer.h>
#include <common/link.h>
#include <common/types.h>
#include <yplatform/module.h>

namespace botserver::db {

class links
{
public:
    virtual void add(task_context_ptr ctx, link link) = 0;
    virtual optional<link> lookup(task_context_ptr ctx, botpeer botpeer) = 0;

    virtual ~links() = default;
};

struct otp_check_result
{
    bool valid = false;
    mail_account mail_account;
    // DB details for logging?
};

class otp
{
public:
    virtual string gen_code(task_context_ptr ctx, botpeer botpeer, mail_account mail_account) = 0;
    virtual otp_check_result check_code(task_context_ptr ctx, botpeer botpeer, string code) = 0;

    virtual ~otp() = default;
};

using links_ptr = shared_ptr<links>;
using otp_ptr = shared_ptr<otp>;

}
