#pragma once

#include <ymod_pq/bind_array.h>

namespace botserver::db {

template <typename T, bool flag = false>
T assert_not_supported_type()
{
    static_assert(flag, "unsupported type");
}

template <typename T>
void add_arg_to_bind(ymod_pq::bind_array_ptr bind, T&& arg)
{
    if constexpr (std::is_same_v<std::string, std::decay_t<T>>)
    {
        ymod_pq::push_const_string(bind, std::forward<T>(arg));
    }
    else if constexpr (std::is_same_v<unsigned, std::decay_t<T>>)
    {
        ymod_pq::push_const_uint(bind, std::forward<T>(arg));
    }
    else
    {
        assert_not_supported_type<T>();
    }
}

template <typename Arg, typename... Args>
void add_all_args_to_bind(ymod_pq::bind_array_ptr bind, Arg&& first, Args&&... rest)
{
    add_arg_to_bind(bind, std::forward<Arg>(first));

    if constexpr (sizeof...(rest) > 0)
    {
        add_all_args_to_bind(bind, std::forward<Args>(rest)...);
    }
}

template <typename... Args>
ymod_pq::bind_array_ptr make_pq_args(Args&&... args)
{
    auto bind = boost::make_shared<ymod_pq::bind_array>();
    add_all_args_to_bind(bind, std::forward<Args>(args)...);
    return bind;
}

}
