#pragma once

#include <common/mail_account.h>
#include <ymod_pq/response_handler.h>

namespace botserver::db {

struct mail_accounts_converter : ymod_pq::response_handler
{
    enum cols
    {
        uid = 0,
        email,

        columns_count
    };

    void handle_cell(unsigned /*row*/, unsigned col, const std::string& value, bool /*is_null*/)
        override
    {
        switch (col)
        {
        case uid:
            current.uid = value;
            break;
        case email:
            current.email = value;
            break;
        default:
            throw std::runtime_error("unknown column");
        }
    }

    void handle_row_end(unsigned /*row*/) override
    {
        result.emplace_back(current);
        current = {};
    }

    unsigned column_count() const override
    {
        return columns_count;
    };

    vector<mail_account> result;
    mail_account current;
};

inline auto make_mail_accounts_converter()
{
    return boost::make_shared<mail_accounts_converter>();
}

}
