#pragma once

#include "common/types.h"

namespace botserver::i18n {

inline bool need_escape(char c)
{
    static const set<char> special_chars{ '\\', '`', '*', '_', '{', '}', '[', ']',
                                          '(',  ')', '#', '+', '-', '.', '!' };
    return special_chars.contains(c);
}

inline string markdown_escape(string str)
{
    std::stringstream ss;
    for (char c : str)
    {
        if (need_escape(c)) ss << '\\';
        ss << c;
    }
    return ss.str();
}

}
