#pragma once

#include "otp_rate_limiter.h"
#include "settings.h"
#include <messenger/gate.h>
#include <mail/sender.h>
#include <db/interface.h>
#include <auth/account_provider.h>
#include <common/gate_message.h>
#include <common/types.h>

namespace botserver::message_processor {

enum class command_name
{
    unknown = 0,
    start,
    ping,
    email,
    code,
    debug,
    forward
};

struct command
{
    command_name name = command_name::unknown;
    map<string, string> args;
};

struct context : task_context
{
    command command;
    gate_message_ptr message;
    botpeer botpeer;
    settings settings;
    messenger::gate_ptr gate;
    db::links_ptr links;
    db::otp_ptr otp;
    mail::sender_ptr mail_sender;
    auth::account_provider_ptr account_provider;
    time_point create_ts = clock::now();
    time_point start_process_ts = clock::now();
    map<string, string> custom_log_data;
    otp_rate_limiter_ptr otp_limiter;

    context(const task_context& ctx) : task_context(ctx)
    {
    }

    i18n::language lang()
    {
        return message->lang;
    }
};

using context_ptr = boost::shared_ptr<context>;

}