#pragma once

#include <message_processor/context.h>
#include <common/gate_message.h>
#include <common/types.h>
#include <yplatform/util/split.h>

namespace botserver::message_processor {

struct parser
{
    vector<string> words;

    command operator()(shared_ptr<gate_message> message)
    {
        words = yplatform::util::split(message->text, " ");
        if (words.empty()) return command{ command_name::forward, {} };
        if (words[0] == "/start")
        {
            return command{ command_name::start, {} };
        }
        if (words[0] == "/debug")
        {
            return command{ command_name::debug, {} };
        }
        if (words[0] == "/ping")
        {
            return command{ command_name::ping, {} };
        }
        if (words[0] == "/email")
        {
            return command{ command_name::email, { { "email", word(1) } } };
        }
        if (words[0] == "/code")
        {
            return command{ command_name::code, { { "code", word(1) } } };
        }
        return command{ command_name::forward, {} };
    }

    string word(size_t i)
    {
        if (words.size() <= i) return "";
        return words[i];
    }
};

}