#pragma once

#include <common/types.h>

namespace botserver::message_processor {

struct rate_limit_settings
{
    uint64_t attempts = 0;
    duration period;

    void parse_ptree(yplatform::ptree conf)
    {
        attempts = conf.get<uint64_t>("attempts");
        period = conf.get<duration>("period");
    }
};

struct settings
{
    string gate_module;
    size_t max_message_size = 0;
    optional<rate_limit_settings> otp_botpeer_limit;
    optional<rate_limit_settings> otp_uid_limit;

    void parse_ptree(yplatform::ptree conf)
    {
        gate_module = conf.get<string>("gate_module");
        max_message_size = conf.get("max_message_size", max_message_size);
        if (auto child = conf.get_child_optional("otp_botpeer_limit"))
        {
            otp_botpeer_limit = rate_limit_settings{};
            otp_botpeer_limit->parse_ptree(*child);
        }
        if (auto child = conf.get_child_optional("otp_uid_limit"))
        {
            otp_uid_limit = rate_limit_settings{};
            otp_uid_limit->parse_ptree(*child);
        }
    }
};

inline settings make_settings(yplatform::ptree conf)
{
    settings ret;
    ret.parse_ptree(conf);
    return ret;
}

}