#pragma once

#include "context.h"
#include <i18n/i18n.h>
#include <common/types.h>

namespace botserver::message_processor {

struct start
{
    void operator()(context_ptr context)
    {
        auto link = get_link(context);
        reply_with_forward_invitation(context);
        if (!link)
        {
            reply_with_bind_invitation(context);
        }
    }

    optional<link> get_link(context_ptr context)
    {
        return context->links->lookup(context, context->botpeer);
    }

    void reply_with_forward_invitation(context_ptr context)
    {
        context->gate
            ->send_message(
                context,
                context->botpeer,
                i18n::forward_and_it_will_be_send_to_email(context->lang()))
            .get();
    }

    void reply_with_bind_invitation(context_ptr context)
    {
        context->gate
            ->send_message(
                context, context->botpeer, i18n::to_start_bind_email_address(context->lang()))
            .get();
    }
};

}