#pragma once

#include <common/gate_message.h>
#include <common/types.h>
#include <boost/regex.hpp>

namespace botserver::message_processor {

inline bool valid_email(string email)
{
    static const boost::regex REGEXP{ "^[^ @]+@[^ @]+$" };
    boost::smatch what;
    return boost::regex_match(email, what, REGEXP);
}

inline bool valid_otp(string otp)
{
    static const boost::regex REGEXP{ "^[0-9]+$" };
    boost::smatch what;
    return boost::regex_match(otp, what, REGEXP);
}

}
