#pragma once

#include <common/botpeer.h>
#include <common/gate_message.h>
#include <common/types.h>

namespace botserver::messenger {

class gate
{
public:
    using message_handler = function<future<void>(task_context_ptr, botpeer, gate_message_ptr)>;

    virtual void set_message_handler(message_handler h) = 0;
    virtual future<void> send_message(task_context_ptr ctx, botpeer peer, string text) = 0;
    virtual future<void> send_message(task_context_ptr ctx, botpeer peer, markdown_string text) = 0;
    virtual future<void> send_message(task_context_ptr ctx, botpeer peer, html_string text) = 0;
    virtual future<string_ptr> download_file(
        task_context_ptr ctx,
        botpeer peer,
        string file_id) = 0;
    virtual void disable_processing(task_context_ptr ctx, duration ttl) = 0;

    virtual ~gate() = default;
};

using gate_ptr = shared_ptr<gate>;

}
