#pragma once

#include <common/types.h>

namespace botserver::messenger::telegram {

struct settings
{
    string bot_id;
    string api_token;
    string bind_path;

    vector<string> allowed_attachment_types;
    set<string> russian_locale_languages;
    set<string> blacklist;
    set<string> whitelist;

    struct
    {
        size_t limit = 0;
        size_t counters_cache_capacity = 0;
    } telegram_retries;

    string link_template;

    void parse_ptree(yplatform::ptree conf)
    {
        bot_id = conf.get<string>("bot_id");
        api_token = conf.get<string>("api_token");
        bind_path = conf.get<string>("bind_path");
        telegram_retries.limit = conf.get<size_t>("telegram_retries.limit");
        telegram_retries.counters_cache_capacity =
            conf.get<size_t>("telegram_retries.counters_cache_capacity");

        yplatform::read_ptree(allowed_attachment_types, conf, "allowed_attachment_types");
        yplatform::read_ptree(russian_locale_languages, conf, "russian_locale_languages");
        yplatform::read_ptree(blacklist, conf, "blacklist");
        yplatform::read_ptree(whitelist, conf, "whitelist");

        link_template = conf.get<string>("link_template");

        if (blacklist.size() && whitelist.size())
            throw runtime_error("blacklist and whitelist enabled at the same time");
    }
};

}
