#include <api/disable_processing.h>
#include <api/ping.h>

#include <ymod_webserver/server.h>
#include <yplatform/module_registration.h>

namespace botserver {

class module : public yplatform::module
{
public:
    void init()
    {
        setup_api_handlers();
    }

private:
    void setup_api_handlers()
    {
        using ymod_webserver::transformer;
        using ymod_webserver::argument;
        using ymod_webserver::optional_argument;

        auto webserver = yplatform::find<ymod_webserver::server>("web_server");
        webserver->bind("", { "/ping" }, api::ping);

        webserver->bind("internal", { "/ping" }, api::ping);
        webserver->bind(
            "internal",
            { "/disable_processing" },
            api::disable_processing,
            transformer(optional_argument<unsigned int>("ttl", 60u)));
    }
};

}

REGISTER_MODULE(botserver::module);
