#pragma once

#include <common/gate_message.h>
#include <common/botpeer.h>
#include <common/types.h>
#include <yplatform/log.h>

namespace botserver::typed {

namespace tl = yplatform::log::typed;

namespace detail {

inline tl::attributes_map make_attrs_map(map<string, string> attrs)
{
    tl::attributes_map ret;
    for (auto [key, value] : attrs)
    {
        ret << tl::make_attr(key, value);
    }
    return ret;
}

}

inline void log_message_processed(
    task_context_ptr ctx,
    string status,
    string reason,
    botpeer botpeer,
    string command_name,
    time_point create_ts,
    time_point start_process_ts,
    map<string, string> extra_attrs)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info)
        << tl::make_attr("type", "message_processed") << tl::make_attr("status", status)
        << tl::make_attr("reason", reason)
        << tl::make_attr("y_context", ctx->uniq_id())
        // << tl::make_attr("platform", botpeer.platform) // XXX log platfrom with magic enum lib
        << tl::make_attr("bot_id", botpeer.bot_id) << tl::make_attr("chat_id", botpeer.chat_id)
        << tl::make_attr("messenger_username", botpeer.username)
        << tl::make_attr("command", command_name)
        << tl::make_attr("rc_wait_time", to_string(start_process_ts - create_ts))
        << tl::make_attr("process_time", to_string(clock::now() - start_process_ts))
        << detail::make_attrs_map(extra_attrs);
}

inline void log_mail_message_sent(
    task_context_ptr ctx,
    string status,
    string reason,
    string smtp_response,
    time_point sent_start_ts,
    botpeer botpeer)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info)
        << tl::make_attr("type", "mail_message_sended") << tl::make_attr("status", status)
        << tl::make_attr("reason", reason)
        << tl::make_attr("y_context", ctx->uniq_id())
        // << tl::make_attr("platform", botpeer.platform) // XXX log platfrom with magic enum lib
        << tl::make_attr("smtp_response", smtp_response)
        << tl::make_attr("sent_time", to_string(clock::now() - sent_start_ts))
        << tl::make_attr("bot_id", botpeer.bot_id) << tl::make_attr("chat_id", botpeer.chat_id)
        << tl::make_attr("messenger_username", botpeer.username);
}

inline void log_download_file(
    task_context_ptr ctx,
    string status,
    string reason,
    botpeer botpeer,
    string file_id,
    size_t file_size)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info)
        << tl::make_attr("type", "download_file") << tl::make_attr("status", status)
        << tl::make_attr("reason", reason)
        << tl::make_attr("y_context", ctx->uniq_id())
        // << tl::make_attr("platform", botpeer.platform) // XXX log platfrom with magic enum lib
        << tl::make_attr("bot_id", botpeer.bot_id) << tl::make_attr("chat_id", botpeer.chat_id)
        << tl::make_attr("messenger_username", botpeer.username)
        << tl::make_attr("file_id", file_id)
        << tl::make_attr("file_size", std::to_string(file_size));
}

inline void log_maintenance(task_context_ptr ctx, string event, map<string, string> extra_attrs)
{
    yplatform::log::tskv_logger log(YGLOBAL_LOG_SERVICE, "typed_log");
    YLOG(log, info) << tl::make_attr("type", "maintenance") << tl::make_attr("event", event)
                    << tl::make_attr("y_context", ctx->uniq_id())
                    << detail::make_attrs_map(extra_attrs);
}

}