# BUTIL
Библиотека с велосипедами для почтовых сервисов

## Компоненты

* **datetime**
    * Функции для работы со временем
        * конвертация в строку определенного формата и обратно
        * перевод в другой часовой пояс

* **email**
    * Сущность `Email` и ее хэлперы

* **http**
    * Извлечение информации из http-запросов и их формирование

* **network**
    * Распознавание яндексовых хостов
    * Извлечение `real-ip` из заголовков
    * IDNA-кодирование и декодирование
    * Работа с почтовыми адресами (rfc 2822)

* **StrUtils**
    * iconv – "обертка" над одноименной библиотекой для преобразования текста между разными кодировками
    * Работа с UTF, qp и base64
    * Хэлперы для работы со строкой
        * `strtr`, `trim`, `unescape` и т.п.
        * Обёртка над `std::string` с методами для манипуляции над подлежащей строкой

* **thread**
    * Реализация блокировки на чтение и запись

* **xml**
    * Хэлперы для работы с xml

* **butil**
    * Реализация кодировка и декодировки qp, base64 и url

* **crypt**
    * Реализация шифрования и дешифрования HMAC и AES

* **digest**
    * Реализация MD5

* **entity_iterator**
    * Итератор для строки по подстрокам с определенным началом и концом

* **Expat**
    * Библиотека для парсинга xml

* **split_key_value**
    * Извлечение ключа и значения из строки

* **strtools**
    * Функции для работы со строкой

* **tvm_ticket**
    * Структура для работы с `tvm_ticket`'ами
