#ifndef EXPAT_H
#define EXPAT_H

/*

$Log$
Revision 1.1  2005/03/10 11:06:40  virtan
Initial revision


*/

#include <string>
#include <expat.h>

class Expat {
    public:
        Expat();
        Expat(const char *enc);
        Expat(const std::string &enc);
        ~Expat();
        void reset();
        void reset(const char *enc);
        void reset(const std::string &enc);
        void setStartElementHandler(XML_StartElementHandler &start);
        void setEndElementHandler(XML_EndElementHandler &end);
        enum XML_Status parse(const char *s, int len, int isFinal=1);
        enum XML_Status parse(const std::string &s);
        enum XML_Status parse(const std::string &s, int isFinal);
        enum XML_Status parse(const std::string &s, int len, int isFinal);
        enum XML_Error errorCode();
        int errorLine();
        int errorColumn();
        const char *error();
        void setUserData(void *userData);
        void *getUserData();


    private:
        XML_Parser parser;
};

#endif
