#pragma once

#include <string>
#include <memory>
#include <iconv.h>

#define ICONV_OK 0
#define ICONV_BADDIRECTION (-2)
#define ICONV_UNKNOWN (-3)

class Iconv
{
    public:
        Iconv(const std::string &from, const std::string &to, bool recover=false);
        ~Iconv();
        void direction(const std::string &from, const std::string &to);
        void tuneCharset(std::string &charset);
        void recover(bool value);
        bool recover();
        int recode(const std::string &source, std::string &dest);
        std::string recode(const std::string &source);
        std::string recode(const std::string &src, char repl);
        bool iserror();
        static const std::string error(int errorCode);
        static int recode(const std::string &from, const std::string &to,
                const std::string &source, std::string &dest, bool recover=false);

    private:
        iconv_t ip;
        std::unique_ptr<char[]> memBuf;
        bool modeRecover;
};
