#ifndef STRESSENTIAL_H
#define STRESSENTIAL_H

#include <string>
#include <vector>
#include <cctype>

typedef std::vector< std::string > StringArray;

namespace TStrUtils
{

    /**
     * Merges [iStart, iEnd) with separator.
     */
    template <class forward_iterator>
    std::string
    merge(forward_iterator iStart,
          forward_iterator iEnd,
          const std::string & sep);

    /**
     * trimming string (using @a what as characters as separators)
     */
    std::string
    trim(const std::string& str,
         const std::string& what="\r\n\t ");

    /**
     * return lowercase string
     */
    std::string
    stringToLower(const std::string& str);

    /**
     * Remove bad symbols from string and replace them with a good symbol
     * @todo Later this function can be extended.
     * This function was extracted from transformers,
     * so maybe we need to generalize it.
     * This function does not replace \r, \n, \t !
     */
    void replaceBadSymbols(std::string& str, const std::string::value_type replaceBy = ' ' );

    /// remove bad symbols from string (nonprintable, except of \r,\n,\t)
    std::string removeBadSymbols( const std::string & str );

    /// remove all bad symbols from string (nonprintable, including \r,\n,\t)
    std::string removeAllBadSymbols( const std::string & str );
    bool isControlChar(char c);


    std::string foldLine(const std::string& line);

    bool isNum(const std::string& s);

    std::string unescape(const std::string& str);

    std::string removeSurroundQuotes(const std::string& str);
}

template <class forward_iterator>
std::string
TStrUtils::
merge(forward_iterator iStart,
      forward_iterator iEnd,
      const std::string & sep)
{
    std::string res;

    if (iEnd != iStart) {
        res = *iStart;
        for(++iStart; iStart != iEnd; ++iStart) {
            res += sep;
            res += *iStart;
        }
    }

    return res;
}

#endif
