#ifndef STRTR_H_2013_11_25
#define STRTR_H_2013_11_25

#include <string>

// analogue to the php strtr function - chars replacement
template <typename ReplaceMap>
void strtr(std::string& str, const ReplaceMap & replaceMap) {
    typedef typename ReplaceMap::const_iterator Iter;
    for ( Iter iter = replaceMap.begin(); iter != replaceMap.end(); iter++) {
        std::string::size_type pos = 0;
        while ((pos = str.find(iter->first, pos)) != std::string::npos) {
            if (iter->second != 0) { // if the replacing char is 0, erase it
                str.replace(pos, 1, 1, iter->second);
            } else {
                str.erase(pos, 1);
            }
        }
    }
}

#endif // STRTR_H_2013_11_25
