/* -*- C++ -*- */
#ifndef baida_butil_h
#define baida_butil_h

#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <butil/strtools.h>
#include <string>

std::string
encode_base64(const std::string& src);

std::string
encode_base64_splitline(const std::string& src);

std::string
decode_base64(const std::string& src);

std::string
decode_base64_mergeparts(const std::string& src);

std::string
encode_qp(const std::string& src);

std::string
decode_qp(const std::string& src);


std::string
encode_url(const std::string& src, bool escape_whitespace = false, const char* skip_chars = "_-.");

std::string
decode_url(const std::string& src);


#endif














