#ifndef DATEUTILS_H
#define DATEUTILS_H

#include <ctime>
#include <string>
#include <cstring>

namespace DateUtils {
    time_t tztime(time_t tt, const std::string& tz);
    time_t tztimeUtc(time_t tt, const std::string& tz);
    std::string tztime2string(time_t tt, const std::string& tz, const std::string& format);
    std::string rfc2822time(time_t tt, const std::string& tz);
    /**
     * Function parses specified time according to the format and returns
     * time representation in seconds since 01.01.1970 normalized to UTC using
     * local machine time zone.
     */
    time_t string2timeFormat( const std::string & time, const std::string & format );

    inline struct tm tmDefault()
    {
        struct tm retval;
        const int noDaylightSavingTimeInfo = -1;
        std::memset( &retval, 0, sizeof(retval));
        retval.tm_isdst = noDaylightSavingTimeInfo;
        return retval;
    }
}

#endif
