#ifndef __EMAIL_H__2013_12_10
#define __EMAIL_H__2013_12_10

#include <string>
#include <vector>
#include <butil/network/rfc2822.h>
#include <butil/network/idn.h>

struct Email
{
public:
    Email()
    {
    }

    Email(const std::string& local, const std::string& domain, const std::string displayName="")
    {
       setLocal(local);
       setDomain(domain);
       setDisplayName(displayName);
    }

    void setLocal( const std::string &local)
    {
        local_=local;
    }
    const std::string& local() const
    {
        return local_;
    }
    void setDomain( const std::string &domain)
    {
        domain_ = idna::encode(domain);
    }
    const std::string& domain() const
    {
        return domain_;
    }
    void setDisplayName( const std::string &displayName)
    {
        displayName_ = displayName;
    }
    const std::string& displayName() const
    {
        return displayName_;
    }
    std::string addressString() const
    {
        return rfc2822ns::join_address(local_, domain_);
    }

private:
    std::string displayName_;
    std::string local_;
    std::string domain_;
};

typedef std::vector<Email> EmailVec;

#endif // __EMAIL_H__2013_12_10
