#pragma once

#include <string>
#include <algorithm>
#include <butil/StrUtils/utfutils.h>
#include <butil/email/login_comparator.h>
#include <butil/email/email.h>
#include <butil/email/yandex_login.h>
#include <butil/network/rfc2822.h>
#include <butil/network/idn.h>
#include <butil/network/domain_check.h>
#include <butil/network/utils.h>

namespace EmailHelpers {

    bool isEmptyAddress(const Email &email);

    bool isValidAddress(const Email &email);

    std::string toString(const Email &email);

    std::string toString(const EmailVec & vec);

    Email fromString(const rfc2822ns::address_iterator it);

    Email fromStringWithoutLowercase(const rfc2822ns::address_iterator it);

    Email fromString(const std::string &email);

    Email fromString(const std::string &email, const std::nothrow_t &);

    EmailVec toEmailVec(const std::string &emails);

    std::string idnaize(const std::string& email);

    bool isEqualEmails(const Email& email1,const Email& email2);

    EmailVec::iterator findEqualEmail(EmailVec &vec, const Email& value);


    struct EmailEqPred {
        EmailEqPred(const std::string & email) {
            split_domain(email, login_, domain_);
        }

        bool operator()(const std::string& email) const {
            std::string login;
            std::string domain;
            split_domain(email, login, domain);

            return login_ == login && boost::algorithm::iequals(domain_, domain);
        }

    private:
        std::string login_;
        std::string domain_;
    };

    struct YandexEmailEqPred {
        YandexEmailEqPred(const std::string & email) {
            split_domain(email, login_, domain_);
        }

        YandexEmailEqPred(const std::string & login, const std::string & domain)
        : login_(login), domain_(domain) {}

        bool operator()(const std::string& email) const {
            std::string login;
            std::string domain;
            split_domain(email, login, domain);

            return loginsEquals(login_, login) && boost::algorithm::iequals(domain_, domain);
        }

    private:
        std::string login_;
        std::string domain_;
    };

}
