#pragma once

#ifndef LOGIN_COMPARATOR_H_2013_12_10
#define LOGIN_COMPARATOR_H_2013_12_10

#include <string>
#include <locale>
#include <algorithm>
#include <functional>
#include <boost/algorithm/string.hpp>

inline std::string loginToCanonicalForm(const std::string& login) {
    std::string res = login.substr(0, login.find('+'));
    std::replace(res.begin(), res.end(), '-', '.');
    return res;
}

inline bool loginsEquals(const std::string& login1, const std::string& login2)
{
    return boost::algorithm::iequals(loginToCanonicalForm(login1), loginToCanonicalForm(login2));
}


#endif // LOGIN_COMPARATOR_H_2013_12_10
