#ifndef ENTITY_ITERATOR_H_110420131254
#define ENTITY_ITERATOR_H_110420131254

#include <string>

template <typename Delimiter>
struct EntityIterator {
    typedef std::string::size_type size_type;
    typedef std::string value_type;

    const std::string * str;
    size_type first;
    size_type last;
    Delimiter beginPattern;
    Delimiter endPattern;

    EntityIterator(const std::string & str, const Delimiter & beginPattern,
            const Delimiter & endPattern, size_type first = 0)
    : str(&str), first(first), last(first),
      beginPattern(beginPattern), endPattern(endPattern) {
        ++(*this);
    }

    EntityIterator() : str(0), first(std::string::npos), last(first) {
    }

    bool operator == ( const EntityIterator & other ) const {
        return str == other.str && first==other.first;
    }

    bool operator != ( const EntityIterator & other ) const {
        return !( *this == other );
    }

    EntityIterator & operator++() {
        if(str) {
            const size_type nextPos = str->find(beginPattern, first);
            if( nextPos==std::string::npos ) {
                *this = EntityIterator();
            } else {
                first = nextPos + beginPattern.length();
                last = str->find(endPattern, first);
                if(last==std::string::npos) {
                    *this = EntityIterator();
                }
            }
        }
        return *this;
    }

    EntityIterator operator++(int) {
        EntityIterator retval(*this);
        ++(*this);
        return retval;
    }

    std::string operator * () const {
        return str->substr(first, last - first);
    }
}; // struct EntityIterator

template <typename T>
class SymbolEntityDelimiter {
    T value;
public:
    SymbolEntityDelimiter() : value( T()) {}
    SymbolEntityDelimiter( const T & value) : value(value) {}

    std::string::size_type length() const {
        return sizeof(T);
    }
    operator char () const {
        return value;
    }
};

#endif /* ENTITY_ITERATOR_H_110420131254 */
