#ifndef HTTP_ERROR_H_2013_12_10
#define HTTP_ERROR_H_2013_12_10

#include <boost/chrono/system_clocks.hpp>
#include <butil/http/url.h>

namespace http {

using namespace boost::chrono;

class error: public std::runtime_error {
public:
    error(const std::string& why, const http::url& url, const milliseconds& time)
        : std::runtime_error(why)
        , url_(url)
        , time_(time)
    {}

    virtual ~error(void) {
    }

    const http::url& url() const {
        return url_;
    }

    milliseconds time() const {
        return time_;
    }

private:
    http::url url_;
    milliseconds time_;
};

class StatusError: public error {
public:
    StatusError(const std::string& why, const http::url& url, const milliseconds& time, int status)
        : error(why, url, time)
        , status_(status)
    {}

    virtual ~StatusError() {
    }

    int status() const {
        return status_;
    }

private:
    int status_;
};

std::string formatForLog(const error& e, int tryCount = 0);
std::string formatForLog(const StatusError& e, int tryCount = 0);

}

#endif // HTTP_ERROR_H_2013_12_10
