#ifndef HEADERS_H_2013_12_12
#define HEADERS_H_2013_12_12

#include <butil/key_value.h>

namespace http {

struct headers {
    using Header = ParameterList;
    using HeaderVector = MultiKeyValue;
    using FlatMap = std::map<std::string, std::string>;

    HeaderVector headers;

    void add(const std::string& name, const std::string& value) {
        if (!name.empty()) {
            headers[name].push_back(value);
        } else {
            throw std::invalid_argument("trying to add header with empty name");
        }
    }

    std::string format() const {
        std::string result;
        for (const auto& headerVector: headers) {
            for (const std::string& header: headerVector.second) {
                result += headerVector.first + ": " + header + "\r\n";
            }
        }

        return result;
    }

    FlatMap flatten() const {
        FlatMap res;
        for (const auto& headerVector: headers) {
            if (headerVector.second.size() > 0) {
                res[headerVector.first] = headerVector.second.front();
            }
        }
        return res;
    }
};



}

#endif // HEADERS_H_2013_12_12
