#pragma once

#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <butil/butil.h>
#include <butil/key_value.h>

namespace http {

inline MultiKeyValue parse(const std::string& str) {
    MultiKeyValue args;

    std::vector<std::string> splitted;
    boost::algorithm::split(splitted, str, boost::is_any_of("&"));

    for (const std::string& s : splitted) {
        std::vector<std::string> singleArg;
        boost::algorithm::split(singleArg, s, boost::is_any_of("="));

        if (singleArg.size() == 2) {
            args[decode_url(singleArg.front())].push_back(decode_url(singleArg.back()));
        } else {
            throw std::runtime_error(std::string("strange param: ") + s);
        }
    }

    return args;
}

}
