#pragma once

#include <butil/http/url_proto.h>

namespace http {
    struct url {
        typedef std::string::size_type size_type;

        url(const std::string& s);
        url& relocate(const std::string& s);

        int port(void) const { return port_; }
        const std::string& source(void) const { return src_; }
        const std::string& server(void) const { return server_; }
        const std::string& uri(void) const { return uri_; }
        const std::string& login() const { return login_; }
        const std::string& password() const { return password_; }
        const std::string& urlPart() const { return urlPart_; }
        bool portSpecified() const { return portSpecified_; }
        std::string protocol() const;
    private:
        void port(int p) {
            port_ = p;
            portSpecified_ = true;
        }
        static int getDefaultPort( UrlProto protocol );
        size_type extractLoginAndPassword( const std::string & url );
        size_type extractPort( const std::string & url, size_type pos );
        size_type extractServerAndPort( const std::string & url, size_type pos );
        void extractUri( const std::string & url, size_type pos );
        void extractUrlPart( const std::string & url );
        UrlProto protocol_;
        std::string src_, server_, uri_, login_, password_, urlPart_;
        int port_;
        bool portSpecified_;
    };
} //namespace http
