#pragma once

#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <boost/optional.hpp>
#include <string>
#include <optional>


namespace real_ip {

namespace detail {

template <typename Optional>
std::string getFromHeaders(Optional xForwardFor, Optional xRealIp, const std::string& remoteAddress) {
    if (xForwardFor && !xForwardFor->empty()) {
        std::vector<std::string> ips;
        boost::algorithm::split(ips, *xForwardFor, boost::is_any_of(", "), boost::algorithm::token_compress_on);

        if (ips.size() >= 1 && !ips[0].empty()) {
            return ips[0];
        }
    }

    if (xRealIp && !xRealIp->empty()) {
        return *xRealIp;
    }

    return remoteAddress;
}

} // namespace detail

inline std::string getFromHeaders(std::optional<std::string> xForwardFor, std::optional<std::string> xRealIp, const std::string& remoteAddress) {
    return detail::getFromHeaders(std::move(xForwardFor), std::move(xRealIp), remoteAddress);
}

inline std::string getFromHeaders(boost::optional<std::string> xForwardFor, boost::optional<std::string> xRealIp, const std::string& remoteAddress) {
    return detail::getFromHeaders(std::move(xForwardFor), std::move(xRealIp), remoteAddress);
}

} // namespace real_ip
