#ifndef YANDEX_DOMAINS_H_2013_12_11
#define YANDEX_DOMAINS_H_2013_12_11

#include <string>
#include <vector>

#include <boost/algorithm/string/predicate.hpp>
#include <boost/bind.hpp>

#include <butil/network/idn.h>

class YandexDomains {
public:
    struct DomainInfo {
        DomainInfo(const std::string& domain, const std::string& topLvlDomain);

        std::string domain;
        std::string topLevelDomain;
        std::string getDomain() const{
            return domain;
        }
    };
    typedef std::vector<DomainInfo>::const_iterator const_iterator;

    const_iterator begin() const;
    const_iterator end() const;
    void add(const std::string& domain, const std::string& topLvlDomain);

    const_iterator find(const std::string& host) const {
        const std::string hostToFind = idna::encode(host);
        return std::find_if(domains_.begin(), domains_.end(), boost::bind(boost::iequals<std::string,std::string>, hostToFind, boost::bind(&DomainInfo::getDomain, _1),std::locale()));
    }

    const_iterator findEnds(const std::string& host) const {
        const std::string hostToFind = idna::encode(host);
        return find_if(domains_.begin(), domains_.end(), boost::bind(boost::iends_with<std::string, std::string>,hostToFind,boost::bind(&DomainInfo::getDomain, _1),std::locale()));
    }

    bool contains(const std::string& host) const;

private:
    std::vector<DomainInfo> domains_;
};


#endif // YANDEX_DOMAINS_H_2013_12_11
