#ifndef SPLIT_KEY_VALUE_H_011120121200
#define SPLIT_KEY_VALUE_H_011120121200

#include <string>
#include <boost/algorithm/string.hpp>

inline std::pair<std::string,std::string> splitPair( const std::string & keyValue, char delimiter ) {
    const std::size_t delimiterPos = keyValue.find(delimiter);
    return std::make_pair(keyValue.substr(0,delimiterPos), keyValue.substr(delimiterPos+1));
}

inline std::pair<std::string,std::string> splitKeyValue( const std::string & keyValue ) {
    return splitPair( keyValue, '=' );
}

inline std::pair<std::string, std::string> splitKeyValueTrimmed(const std::string& keyValue) {
    std::pair<std::string, std::string> res = splitKeyValue(keyValue);
    return std::make_pair(boost::trim_copy(res.first), boost::trim_copy(res.second));
}

#endif /* SPLIT_KEY_VALUE_H_011120121200 */
