#ifndef STRTOOLS_H
#define STRTOOLS_H

#include <cstdio>
#include <cstring>
#include <string>

static const int  MAX_DIG=40;
 
static const int cs_diff=static_cast<int>('A'-'a');

inline int 
a_tolower(int c)
{  
  return (c>='A' && c<='Z')?(c-cs_diff):c;
}

inline bool 
a_islower(int c)
{  
  return (c>='a' && c<='z');
}

inline int 
a_isupper(int c)
{  
  return (c>='A' && c<='Z');
}

inline int 
a_isdigit(int c)
{  
  return (c>='0' && c<='9');
}


inline int 
a_isspace(int c)
{  
  return (c==' ' || c=='\t' || c=='\r' || c=='\f' || c=='\n' || c=='\n');
}




inline int 
a_isxdigit(int c)
{  
  int k=a_tolower(c);
  return a_isdigit(c) || (k>='a' && k<='f');
}

inline int 
a_isalnum(int c)
{  
  int k=a_tolower(c);
  return a_isdigit(c) || (k>='a' && k<='z');
}



inline std::string 
tolow(const std::string &s)
{
  std::string r(s.length(),'\0');
  for(std::string::size_type i=0;i<s.length();++i)
   r[i]=static_cast<char>(a_tolower(s[i]));
  return r;
}


inline std::string::size_type 
str_span(const std::string& line,std::string::size_type& pos,const char* wh)
{
  if (pos<line.length()) {
    pos+=strspn(line.c_str()+pos,wh);
  }
  return pos;
}

#endif
