#ifndef PTHREAD_EXCEPTION_H_2013_11_26
#define PTHREAD_EXCEPTION_H_2013_11_26

#include <exception>

const char* b_strerror(int e);

class pthread_exception: public std::exception {
public:
  pthread_exception(int e,const char* l=0): error_number(e),fline(l)
  {

  }
  virtual const char* what () const noexcept
  {
    return b_strerror(error_number);
  }
  const char* fname()
  {
    return fline?fline:"unknown";
  }
  int error_number;
  const char* fline;
};

#define ECHECK(a) do { int e=a; \
 if (e!=0) { \
    throw pthread_exception(e,__PRETTY_FUNCTION__); \
 } } while(0)

#endif // PTHREAD_EXCEPTION_H_2013_11_26
