#ifndef RWLOCK_H_2013_11_26
#define RWLOCK_H_2013_11_26

#include <pthread.h>
#include <butil/thread/pthread_exception.h>

class rwlock {
public:
  class attribute {
  public:
#ifdef HAVE_PREFER_RWL
    enum kind {
       reader = PTHREAD_RWLOCK_PREFER_READER_NP,
       writer = PTHREAD_RWLOCK_PREFER_WRITER_NP,
       writernonrecursive = PTHREAD_RWLOCK_PREFER_WRITER_NONRECURSIVE_NP,
       rwdefault = PTHREAD_RWLOCK_DEFAULT_NP,
    };
#endif


    enum pshared {
      priv = PTHREAD_PROCESS_PRIVATE,
      shared = PTHREAD_PROCESS_SHARED
    };

    attribute& setpshared(pshared k) {
      ECHECK(pthread_rwlockattr_setpshared(&mattr,k));
      return *this;
    }

    pshared getpshared(void) const {
      int k = priv;
      pthread_rwlockattr_getpshared(&mattr,&k);
      return pshared(k);
    }

#ifdef HAVE_PREFER_RWL
    attribute& setkind(kind k) {
      ECHECK(pthread_rwlockattr_setkind_np(&mattr,k));
      return *this;
    }

    kind getkind(void) const {
      int k = rwdefault;
      pthread_rwlockattr_getkind_np(&mattr,&k);
      return (kind) k ;
    }

    attribute(kind k,pshared p=priv)
    {
      pthread_rwlockattr_init(&mattr);
      setkind(k);
      setpshared(p);
    }
#else
    attribute(pshared p)
    {
      pthread_rwlockattr_init(&mattr);
      setpshared(p);
    }
#endif

    attribute(void)
    {
      pthread_rwlockattr_init(&mattr);
    }

    ~attribute()
    {
      pthread_rwlockattr_destroy(&mattr);
    }

    attribute(const attribute& a) {
      pthread_rwlockattr_init(&mattr);
#ifdef HAVE_PREFER_RWL
      setkind(a.getkind());
#endif
      setpshared(a.getpshared());
    }

    attribute& operator=(const attribute& a) {
      if (&a != this) {
#ifdef HAVE_PREFER_RWL
    setkind(a.getkind());
#endif
    setpshared(a.getpshared());
      }
      return *this;
    }

    pthread_rwlockattr_t& handle(void)
    {
      return mattr;
    }

  private:
    pthread_rwlockattr_t mattr;
  };

  rwlock( const attribute& a): at(a)
  {
    ECHECK(pthread_rwlock_init(&mux_,&at.handle()));
  }

  rwlock(void): at()
  {
    ECHECK(pthread_rwlock_init(&mux_,&at.handle()));
  }

  ~rwlock()
  {
    pthread_rwlock_destroy(&mux_);
  }

  attribute& attr(void)
  {
    return at;
  }
  void lock_read(void)
  {
    ECHECK(pthread_rwlock_rdlock(&mux_));
  }
  int trylock_read(void)
  {
    return pthread_rwlock_tryrdlock(&mux_);
  }

  void lock_write(void)
  {
    ECHECK(pthread_rwlock_wrlock(&mux_));
  }

  int trylock_write(void)
  {
    return pthread_rwlock_trywrlock(&mux_);
  }

  void unlock(void)
  {
    ECHECK(pthread_rwlock_unlock(&mux_));
  }

  pthread_rwlock_t& handle(void)
  {
    return mux_;
  }

private:
  attribute at;
  pthread_rwlock_t mux_;
};

#endif
