#pragma once

#include <string>

namespace tvm {

class Ticket {
    std::string uid_;
    std::string ticket_;

public:
    std::string uid() const {
        return uid_;
    }

    std::string ticket() const {
        return ticket_;
    }

    Ticket& setUid(const std::string& uid) {
        uid_ = uid;
        return *this;
    }

    Ticket& setTicket(const std::string& ticket) {
        ticket_ = ticket;
        return *this;
    }
};

inline std::string headerName() { return "ticket"; }

}
