#ifndef ENTITIES_H_2013_11_23
#define ENTITIES_H_2013_11_23

#include <string>
#include <map>
#include <boost/bimap.hpp>
#include <butil/entity_iterator.h>

class XmlEntities {
public:
    XmlEntities(){
        addEntity('&', "amp");
        addEntity('\'', "apos");
        addEntity('>', "gt");
        addEntity('<', "lt");
        addEntity('"', "quot");
    }
    const std::string & entity( char glyph ) const {
        return get(map.right, glyph, empty);
    }
    std::string printEntity( char glyph ) const {
        return std::string("&") + entity(glyph) + ';';
    }

    char glyph( const std::string & entity ) const {
        return get(map.left, entity, char(0));
    }
protected:
    template <typename T, typename Key, typename Value>
    static const Value & get( const T & map, const Key & key, const Value & defVal ) {
        typename T::const_iterator i(map.find(key));
        return i==map.end() ? defVal : i->second;
    }

    void addEntity( char glyph, const std::string & entity ) {
        map.insert(Map::value_type(entity, glyph));
    }
private:
    typedef boost::bimap<std::string,char> Map;
    Map map;
    std::string empty;
};

typedef SymbolEntityDelimiter<char> XmlEntityDelimiter;

struct XmlEntityIterator : public EntityIterator<XmlEntityDelimiter>{
    XmlEntityIterator(const std::string & str)
    : EntityIterator<XmlEntityDelimiter>(str, '&', ';') {
    }
    XmlEntityIterator() {}
};

std::string & decodeXmlEntities( std::string & src );
std::string & encodeXmlEntities( std::string & src );


#endif // ENTITIES_H_2013_11_23
