#ifndef HELPERS_H_2013_11_26
#define HELPERS_H_2013_11_26

#include <libxml/tree.h>
#include <memory>
#include <string>
#include <iterator>

/// @warning Those releasers also can be found in libxml_helpers.
namespace XmlHelpers {
    /**
     * Casts xmlChar* to to const char*
     * Use only if you sure that xmlchar is in ASCII
     * For more info: http://xmlsoft.org/encoding.html
     *
     */
    inline const char* x2c(const xmlChar* xmlchar) {
        // we assume that XML is in ASCII, so xmlChar* is simple char* .
        return reinterpret_cast<const char*>(xmlchar);
    }

    /**
     * Casts char* to xmlChar* . Be sure that s in utf8.
     */
    inline const xmlChar * c2x(const char *cppchar)
    {
        return reinterpret_cast<const xmlChar*>(cppchar);
    }

    inline const xmlChar * c2x(const std::string& s)
    {
        return reinterpret_cast<const xmlChar*>(s.c_str());
    }
}


#endif // HELPERS_H_2013_11_26
