#include <butil/Expat.h>

/*

$Log$
Revision 1.1  2005/03/10 11:06:40  virtan
Initial revision


*/

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wold-style-cast"

Expat::Expat() {
    parser=XML_ParserCreate(NULL);
};

Expat::Expat(const char *enc) {
    parser=XML_ParserCreate(enc);
};

Expat::Expat(const std::string &enc) {
    parser=XML_ParserCreate(enc.c_str());
};

Expat::~Expat() {
    XML_ParserFree(parser);
};

void Expat::reset() {
    XML_ParserReset(parser,NULL);
};

void Expat::reset(const char *enc) {
    XML_ParserReset(parser,enc);
};

void Expat::reset(const std::string &enc) {
    XML_ParserReset(parser,enc.c_str());
};

void Expat::setStartElementHandler(XML_StartElementHandler &start) {
    XML_SetStartElementHandler(parser,start);
};

void Expat::setEndElementHandler(XML_EndElementHandler &end) {
    XML_SetEndElementHandler(parser,end);
};

enum XML_Status Expat::parse(const char *s, int len, int isFinal) {
    return XML_Parse(parser,s,len,isFinal);
};

enum XML_Status Expat::parse(const std::string &s) {
    return XML_Parse(parser,s.data(),int(s.size()),1);
};

enum XML_Status Expat::parse(const std::string &s, int isFinal) {
    return XML_Parse(parser,s.data(),int(s.size()),isFinal);
};

enum XML_Status Expat::parse(const std::string &s, int len, int isFinal) {
    return XML_Parse(parser,s.data(),len,isFinal);
};

enum XML_Error Expat::errorCode() {
    return XML_GetErrorCode(parser);
};

int Expat::errorLine() {
    return int(XML_GetCurrentLineNumber(parser));
};

int Expat::errorColumn() {
    return int(XML_GetCurrentColumnNumber(parser));
};

const char *Expat::error() {
    return XML_ErrorString(errorCode());
};

void Expat::setUserData(void *userData) {
    XML_SetUserData(parser, userData);
};

void *Expat::getUserData() {
    return XML_GetUserData(parser);
};

#pragma GCC diagnostic pop

